
#include "PIC24F_periph_features.h"
#include "HardwareProfile.h"
#include "MainDemo.h"
static volatile int InternalTicks = 0;
static volatile int TenMilliSecondTicks = 0;
extern BOOL EncryptionInProgress;
void LcdPrintString (BYTE *);
void I2Cinit(void);
void Tick2Init(void);
void delay_usec(int );
int Get_Two_Reg(int);
extern unsigned long Get_Three_Reg( unsigned int  );
#define I2C_BRG	= 157 // ((FCY/Fsck)-(FCY/10,000,000)-1)
//#define OneLine   // comment out for two lines
volatile int areg;  
volatile int breg; 
volatile int creg; 
volatile int accum_areg;  
volatile int accum_breg; 
volatile int accum_creg;
volatile long number_of_seconds;
volatile unsigned int  OneMs;
int stringIndx = 0;
int Lcd_Busy = 0;
int LcdState= 0;
int NewLine = 0;
char LCDText[20];
int lineone=0;
char MyString[20];
void LCDInit(void);
extern volatile unsigned long avrms;
extern volatile unsigned long bvrms;
extern volatile unsigned long cvrms;
extern volatile unsigned long airms;
extern volatile unsigned long birms;
extern volatile unsigned long cirms;
extern POWER_READINGS PowerReadings;
extern double wh_lsb; 
extern volatile int areg_temp;
extern volatile int breg_temp;
extern volatile int creg_temp; 
/*********************************************************************************************************
Calls in this function


void LcdPrintString (LcdBuf) pass quoted string or string var and it will display;

void TickInit(void)
void _ISR __attribute__((__no_auto_psv__)) _T2Interrupt(void)
void PrintControl(void)
void LCDinit(void)
void I2Cinit(void) Inits i2c module speed 157 which is 100KHz with a 16M FCY it seems to work at any speed but i2c speed not a factor

this is a non blocking routine. if prints are tried while previous print is active the command is ignored



Cut and paste into main.c program

extern void I2Cinit(void);
extern void LcdPrintString (void);
extern void PrintControl(void);
extern void LCDinit(void);
extern int TenMs;
extern void Tick2Init(void)
*/

/*=============================================================================
I2C Peripheral Initialisation called from main 
=============================================================================*/   
void I2Cinit(void)
{   
  	I2C1BRG =157; //I2C_BRG;     // set brg for scl rate
	I2C1CONbits.I2CEN=1;   // turn on i2c module
}



void Tick2Init(void)
{
	// Use Timer 1 for 16-bit and 32-bit processors
	// 1:256 prescale
	T2CONbits.TCKPS = 3;
	// Base
	PR2 = 0xf424; // 1 sec  COUNT
	// Clear counter
	TMR2 = 0;

	
	IPC1bits.T2IP = 2;	// Interrupt priority 2 (low)
	IFS0bits.T2IF = 0;
	IEC0bits.T2IE = 1;

	// Start timer
	T2CONbits.TON = 1;

}

void _ISR __attribute__((__no_auto_psv__)) _T2Interrupt(void)

{
	// Increment internal high tick counter
//	InternalTicks++;		// note must declare as volatile or it won't work
//	TenMilliSecondTicks++; 	 // note must declare as volatile
//	OneMs++;

	areg =(Get_Two_Reg(0x01)); // accum in areg in case we get more then one interrupt before main clears
	breg =(Get_Two_Reg(0x02)); 	
	creg =(Get_Two_Reg(0x03));


	areg = (areg+areg_temp ); // add any valuse captured during
	breg = (breg+breg_temp ); // bit 14 interrupt see ADE7758.c		
	creg = (creg+creg_temp );
	areg_temp = 0; // must clear here 
	breg_temp = 0;
	creg_temp = 0;




	PowerReadings.Accum_A_Reg = PowerReadings.Accum_A_Reg+areg; // accumulate total A reg RAW readings
	PowerReadings.Accum_B_Reg = PowerReadings.Accum_B_Reg+breg; // accumulate total B reg RAW readings
	PowerReadings.Accum_C_Reg = PowerReadings.Accum_C_Reg+creg; // accumulate total c reg RAW readings
	
	avrms  = (Get_Three_Reg(0x0D)); 
	bvrms  = (Get_Three_Reg(0x0E)); 	
	cvrms  = (Get_Three_Reg(0x0F));
	airms  = (Get_Three_Reg(0x0A));
	birms  = (Get_Three_Reg(0x0B));
	cirms  = (Get_Three_Reg(0x0C));

	LED0_IO ^= 1;
	if(EncryptionInProgress)
		asm("CLRWDT");
	number_of_seconds++;
	// Reset interrupt flag
	IFS0bits.T2IF = 0;
}

void LcdPrintString(BYTE  *Lcdbuf)
{

	I2C1CONbits.SEN = 0x01;		//Send the Start Bit
	delay_usec(10000);

	I2C1TRN = 0x78; 	// send slave address
	delay_usec(10000);
	delay_usec(20);				
	I2C1TRN = 0x00; 	// send all following bytes are control bytes
	delay_usec(10000);
    //I2C1TRN = 0x01; 	// clear display
    delay_usec(10000);
	I2C1TRN = 0x80; 	// start position
	delay_usec(10000);
	if(lineone)
	{
    	I2C1TRN = 0x80; 	// start position
		lineone = 0;
	}
	else
	{
		lineone =1;
		I2C1TRN = 0xC0; 	// start position
	}
		
	
	delay_usec(10000);
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	delay_usec(10000);
	
    I2C1CONbits.SEN = 0x01;	//Send the start condition
	delay_usec(10000);
	
	I2C1TRN = 0x78; 	// send slave address	
	delay_usec(10000);
	
	I2C1TRN = 0x40; 	// Following data display bytes
	delay_usec(10000);
	
    for(stringIndx = 0;stringIndx < 19;stringIndx++)
 	{
		if (*Lcdbuf != 0)
			I2C1TRN = *Lcdbuf++;  
		else
			I2C1TRN = 0x20;
	delay_usec(10000);
		
	}
		
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	     
}


void delay_usec(int i)
{
	
	while(i >0)
	{
	
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		Nop();
		
		i--;

	}

}






















/*
delay10ms()
{
	TenMilliSecondTicks = 0;
	while(TenMilliSecondTicks == 0);
}

*/

void LCDinit()
{
	/*
	 *	Write one byte to designated address. [1]
	 */
delay_usec(10000);
	I2C1CONbits.SEN = 0x01;				//Send the Start Bit
delay_usec(1000);
	I2C1TRN = 0x78;						// slave address
delay_usec(1000);
	I2C1TRN = 0x00;						// following bytes are control bytes
delay_usec(1000);
	I2C1TRN =  0x38;					//8 bit bus
#if defined OneLine
	delay_usec(1000);
	I2C1TRN = 0x35;						// 35= ONE LINE 39 = 2 LINES
#else
delay_usec(1000);
	I2C1TRN = 0x39;						// 35= ONE LINE 39 = 2 LINES
#endif
delay_usec(1000);
	I2C1TRN = 0x14;						// set cursor display
delay_usec(1000);
	I2C1TRN = 0x78;						//low byteset contrast low four bits control amoumt
delay_usec(1000);
	I2C1TRN = 0x5E;						//high byte contrast
delay_usec(1000);
	I2C1TRN = 0x6D;						//cgram set ???????????????????????? 
delay_usec(1000);
	I2C1TRN = 0x0C;						// turn on display
delay_usec(1000);
	I2C1TRN = 0x01;						// clear display
delay_usec(10000);
	I2C1TRN = 0x06;						// shift right
delay_usec(1000);
	I2C1TRN = 0x80;						// start position 80 starts in left most position 81 second from left etc
delay_usec(1000);
	I2C1CONbits.PEN =0x01;				//Send the Stop condition
	
}

void Clear_lcd(void)

{
delay_usec(10000);	
I2C1CONbits.SEN = 0x01;		//Send the Start Bit
	delay_usec(10000);

	I2C1TRN = 0x78; 	// send slave address
	delay_usec(10000);
	I2C1TRN = 0x00; 	// send all following bytes are control bytes
	delay_usec(10000);
    I2C1TRN = 0x01; 	// clear display
    delay_usec(10000);
	I2C1TRN = 0x80; 	// start position
	delay_usec(10000);
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	delay_usec(10000);
		
	
	
	
	
	
	
	
}






 void Print_Line_One(BYTE  *Lcdbuf)
{
	delay_usec(10000);
	I2C1CONbits.SEN = 0x01;		//Send the Start Bit
	delay_usec(1000);

	I2C1TRN = 0x78; 	// send slave address
	delay_usec(1000);
	I2C1TRN = 0x00; 	// send all following bytes are control bytes
	delay_usec(1000);
    //I2C1TRN = 0x01; 	// clear display
    delay_usec(1000);
	I2C1TRN = 0x80; 	// start position
	delay_usec(1000);
	I2C1TRN = 0x80; 	// start position
	delay_usec(1000);
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	delay_usec(1000);
	I2C1CONbits.SEN = 0x01;	//Send the start condition
	delay_usec(1000);
	I2C1TRN = 0x78; 	// send slave address	
	delay_usec(1000);
	I2C1TRN = 0x40; 	// Following data display bytes
	delay_usec(1000);
	
    for(stringIndx = 0;stringIndx < 20;stringIndx++)  //BOB
 	{
		if (*Lcdbuf != 0)
			I2C1TRN = *Lcdbuf++;  
		else
			I2C1TRN = 0x20;
			delay_usec(100); //BOB
		
	}
	delay_usec(1000);	
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	     
}
 
  
  
 void Print_Line_Two(BYTE  *Lcdbuf)
{
	delay_usec(10000);
	I2C1CONbits.SEN = 0x01;		//Send the Start Bit
	delay_usec(1000);
	I2C1TRN = 0x78; 	// send slave address
	delay_usec(1000);
	I2C1TRN = 0x00; 	// send all following bytes are control bytes
	delay_usec(1000);
    //I2C1TRN = 0x01; 	// clear display
    delay_usec(1000);
    I2C1TRN = 0xc0; 	// start position
	delay_usec(1000);
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	delay_usec(1000);
	I2C1CONbits.SEN = 0x01;	//Send the start condition
	delay_usec(1000);
	I2C1TRN = 0x78; 	// send slave address	
	delay_usec(1000);
	I2C1TRN = 0x40; 	// Following data display bytes
	delay_usec(1000);
	
    for(stringIndx = 0;stringIndx < 20;stringIndx++)
 	{
		if (*Lcdbuf != 0)
			I2C1TRN = *Lcdbuf++;  
		else
			I2C1TRN = 0x20;
	delay_usec(100);
		
	}
		
	I2C1CONbits.PEN = 0x01;	//Send the Stop condition
	     
}
 
 void LCDinit_one_line()
{
	/*
	 *	Write one byte to designated address. [1]
	 */
delay_usec(1000);
I2C1CONbits.SEN = 0x01;				//Send the Start Bit
delay_usec(1000);
I2C1TRN = 0x78;						// slave address
delay_usec(1000);
	I2C1TRN = 0x00;						// following bytes are control bytes
delay_usec(1000);
	I2C1TRN =  0x38;					//8 bit bus
delay_usec(1000);
I2C1TRN = 0x35;						// 35= ONE LINE 39 = 2 LINES
delay_usec(1000);
	I2C1TRN = 0x14;						// set cursor display
delay_usec(1000);
	I2C1TRN = 0x78;						//low byteset contrast low four bits control amoumt
delay_usec(1000);
	I2C1TRN = 0x5E;						//high byte contrast
delay_usec(1000);
	I2C1TRN = 0x6D;						//cgram set ???????????????????????? 
delay_usec(1000);
	I2C1TRN = 0x0C;						// turn on display
delay_usec(1000);
	I2C1TRN = 0x01;						// clear display
delay_usec(10000);
	I2C1TRN = 0x06;						// shift right
delay_usec(1000);
	I2C1TRN = 0x80;						// start position 80 starts in left most position 81 second from left etc
delay_usec(1000);
	I2C1CONbits.PEN =0x01;				//Send the Stop condition
	
}


 void LCDinit_two_line()
{
	/*
	 *	Write one byte to designated address. [1]
	 */
delay_usec(1000);
I2C1CONbits.SEN = 0x01;				//Send the Start Bit
delay_usec(1000);
I2C1TRN = 0x78;						// slave address
delay_usec(1000);
	I2C1TRN = 0x00;						// following bytes are control bytes
delay_usec(1000);
	I2C1TRN =  0x38;					//8 bit bus
delay_usec(1000);
I2C1TRN = 0x39;						// 35= ONE LINE 39 = 2 LINES
delay_usec(1000);
	I2C1TRN = 0x14;						// set cursor display
delay_usec(1000);
	I2C1TRN = 0x78;						//low byteset contrast low four bits control amoumt
delay_usec(1000);
	I2C1TRN = 0x5E;						//high byte contrast
delay_usec(1000);
	I2C1TRN = 0x6D;						//cgram set ???????????????????????? 
delay_usec(1000);
	I2C1TRN = 0x0C;						// turn on display
delay_usec(1000);
	I2C1TRN = 0x01;						// clear display
delay_usec(1000);
	I2C1TRN = 0x06;						// shift right
delay_usec(1000);
	I2C1TRN = 0x80;						// start position 80 starts in left most position 81 second from left etc
delay_usec(1000);
	I2C1CONbits.PEN =0x01;				//Send the Stop condition
}
